
function draw_life_expectance() {

    var data = [[54.16], [56.47], [55.29]];
    
    var chart = $.jqplot('life_expectance', data, {
        seriesDefaults:{
            renderer:$.jqplot.BarRenderer,
            rendererOptions: {
                barMargin: 100
            },
            pointLabels: {show: true}
        },
        axes:{
            xaxis:{
                renderer: $.jqplot.CategoryAxisRenderer,
                ticks: ['']
            },
            yaxis:{
                max: 60,
                min: 50
            }
        },
        legend: {
            show: true,
            location: 'nw',
            xoffset: 10,
            yoffset: 10, 
        },
        series:[{
            label: 'Mehed',
            color: '#0000ff'
        },{
            label: 'Naised',
            color: '#ff0000'
        },{
            label: 'Keskmine',
            color:'#00ff00'
        }],
        highlighter: {
            show: false,
            sizeAdjust: 10
        },
        cursor: {
            show: false
        }
    });
}

$(window).resize(function () {
    $('#life_expectance').empty();
    draw_life_expectance();
});

draw_life_expectance();