
function draw_population_pyramid() {

    var data = {
        'male': {
            '0-4':   2059632,
            '5-9':   1786071,
            '10-14': 1494382,
            '15-19': 1228390,
            '20-24': 1019343,
            '25-29': 846470,
            '30-34': 686986,
            '35-39': 551712,
            '40-44': 437081,
            '45-49': 361242,
            '50-54': 299133,
            '55-59': 240037,
            '60-64': 185052,
            '65-69': 125906,
            '70-74': 88017,
            '75-79': 53114,
            '80-84': 25436,
            '85-89': 8889,
            '90-94': 2018,
            '95-99': 268,
            '100+':  20
        },
        'female': {
            '0-4':   2084926,
            '5-9':   1797483,
            '10-14': 1500800,
            '15-19': 1225905,
            '20-24': 1001968,
            '25-29': 824752,
            '30-34': 672862,
            '35-39': 541561,
            '40-44': 426413,
            '45-49': 346395,
            '50-54': 277896,
            '55-59': 214690,
            '60-64': 160187,
            '65-69': 107085,
            '70-74': 71894,
            '75-79': 41058,
            '80-84': 18047,
            '85-89': 5592,
            '90-94': 1086,
            '95-99': 120,
            '100+':  7
        }
    };
    
    var $pyramid = $('.population_pyramid'),
        $total_population  = $('.total_population'),
        $male_population   = $('.male_population'),
        $female_population = $('.female_population'),
        total_population   = 0,
        male_population    = 0,
        female_population  = 0,
        male_percentage    = 0,
        female_percentage  = 0,
        max_value = 0,
        width = $pyramid.width()/2;
    
    $.each(data, function (i, gender) {
        $.each(gender, function (j, value) {
            total_population += value;
            if (max_value < value) {
                max_value = value;
            }
            if (i === 'male') {
                male_population += value;
            }
            else if (i === 'female') {
                female_population += value;
            }
        })
    });
    
    male_percentage = format_percentage_value(male_population * 100 / total_population) + '%';
    female_percentage = format_percentage_value(female_population * 100 / total_population) + '%';
    male_population = format_absolute_value(male_population);
    female_population = format_absolute_value(female_population);
    
    function set_total_values () {
        $male_population.html('Mehed: ' + male_population + ' (' + male_percentage + ')');
        $female_population.html('Naised: ' + female_population + ' (' + female_percentage + ')');
        $total_population.html('Rahvaarv: ' + format_absolute_value(total_population));
    }
    
    set_total_values();
    
    
    
    $.each(data.male, function (age_range, value) {
        var male_pop   = value,
            female_pop = data.female[age_range.toString()],
            male_perc  = (male_pop * 100 / total_population),
            female_perc  = (female_pop * 100 / total_population),
            male   = Math.ceil(value * width / max_value),
            female = Math.ceil(female_pop * width / max_value),
            age_pop = male_pop + female_pop,
            age_perc = (age_pop * 100 / total_population),
            row = $('<li class="age"><span class="age_range">' + age_range
            + '</span><span class="male" style="width:' + Math.ceil(male_pop * width / max_value)
            + 'px;" title="Mehed ' + age_range + ': ' + format_absolute_value(male_pop) +
            '"></span><span class="female" style="width:' + Math.ceil(female_pop * width / max_value)
            + 'px;" title="Naised ' + age_range + ': ' + format_absolute_value(female_pop)
            + '"></span></li>');
        row.data({
            'age_range':         age_range,
            'male_population':   format_absolute_value(male_pop),
            'male_percentage':   format_percentage_value(male_perc) + '%',
            'female_population': format_absolute_value(female_pop),
            'female_percentage': format_percentage_value(female_perc) + '%',
            'age_population':    format_absolute_value(age_pop),
            'age_percentage':    format_percentage_value(age_perc) + '%'
        });
        $pyramid.prepend(row);
    });

    $pyramid.off('mouseover').on('mouseover', '.age', function () {
        $male_population.html('Mehed: ' + $(this).data('male_population') + ' (' + $(this).data('male_percentage') + ')');
        $female_population.html('Naised: ' + $(this).data('female_population') + ' (' + $(this).data('female_percentage') + ')');
        $total_population.html('Rahvaarv ' + $(this).data('age_range') + ': ' + $(this).data('age_population') + ' (' + $(this).data('age_percentage') + ')');
    });
    
    $pyramid.off('mouseout').on('mouseout', '.age', function () {
        set_total_values();
    });

}


function format_absolute_value (value) {
    return number_format(value, 0, '.', "'");
}

function format_percentage_value (value) {
    if (value < 0.05) {
        return number_format(value, 5, '.', '');
    } else if (value < 1) {
        return number_format(value, 3, '.', '');
    } else {
        return number_format(value, 2, '.', '');
    }
}

function number_format (number, decimals, dec_point, thousands_sep) {
    number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
    var n = !isFinite(+number) ? 0 : +number,
        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
        s = '',
        toFixedFix = function(n, prec) {
            var k = Math.pow(10, prec);
            return '' + (Math.round(n * k) / k).toFixed(prec);
        };
    s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
    if (s[0].length > 3) {
        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
    }
    if ((s[1] || '')
        .length < prec) {
        s[1] = s[1] || '';
        s[1] += new Array(prec - s[1].length + 1)
        .join('0');
    }
    return s.join(dec);
}

$(window).resize(function () {
    $('.population_pyramid .age').remove();
    draw_population_pyramid();
});

draw_population_pyramid();