
function draw_population_trends() {
    var data = [[
        ['1950', 4148000],
        ['1955', 4542000],
        ['1960', 4963000],
        ['1965', 5431000],
        ['1970', 5926000],
        ['1975', 6637000],
        ['1980', 7638000],
        ['1985', 9066000],
        ['1990', 10335000],
        ['1995', 12105000],
        ['2000', 13926000],
        ['2005', 16489000],
        ['2010', 19082000],
        ['2014', 19088106]
    ], [
        ['1950', 1708976],
        ['1955', 1925808],
        ['1960', 2168831],
        ['1965', 2460243],
        ['1970', 2725960],
        ['1975', 3066294],
        ['1980', 3551670],
        ['1985', 4261020],
        ['1990', 4909125],
        ['1995', 5761980],
        ['2000', 6642702],
        ['2005', 7848764],
        ['2010', 8892212],
        ['2014', 8246061]
    ], [
        ['1950', 2310436],
        ['1955', 2493558],
        ['1960', 2660168],
        ['1965', 2824120],
        ['1970', 3040038],
        ['1975', 3391507],
        ['1980', 3880104],
        ['1985', 4569264],
        ['1990', 5157165],
        ['1995', 6028290],
        ['2000', 6949074],
        ['2005', 8228011],
        ['2010', 9712738],
        ['2014', 10269401]
    ], [
        ['1950', 128588],
        ['1955', 122634],
        ['1960', 134001],
        ['1965', 146637],
        ['1970', 160002],
        ['1975', 179199],
        ['1980', 206226],
        ['1985', 244782],
        ['1990', 268710],
        ['1995', 302625],
        ['2000', 348150],
        ['2005', 412225],
        ['2010', 477050],
        ['2014', 553555]
    ]];
    
    var chart = $.jqplot('population_trends', data, {
        axes:{
            xaxis:{
                ticks: ['1950', '1955', '1960', '1965', '1970', '1975', '1980', '1985', '1990', '1995', '2000', '2005', '2010', '2014'],
                renderer:$.jqplot.DateAxisRenderer,
                tickOptions:{
                    formatString:'%Y'
                },
            },
            yaxis:{
                tickOptions:{
                    //formatString:'$%.2f'
                },
                max: 20000000,
                min: 100000
            }
        },
        legend: {
            show: true,
            location: 'nw',
            xoffset: 10,
            yoffset: 10, 
        },
        series:[{
            label: 'Rahvaarv kokku',
            color: '#ff0000'
        },{
            label: 'Vanuses 0–14',
            color: '#00ff00'
        },{
            label: 'Vanuses 15–64',
            color:'#0000ff'
        },{
            label: 'Vanuses 65+',
            color: '#ff00ff'
        }],
        highlighter: {
            show: true,
            sizeAdjust: 10
        },
        cursor: {
            show: false
        }
    });
}

$(window).resize(function () {
    $('#population_trends').empty();
    draw_population_trends();
});

draw_population_trends();